﻿-- Hear Kitty by Vger-Azjol-Nerub
-- See Readme.htm for more information.

------------------------------------------------------------

local KittyUICancelOptions = { }

------------------------------------------------------------
-- Interface Options
------------------------------------------------------------

function KittyUI_OnLoad()
	-- Register the Interface Options page.
	KittyUIFrame.name = "Hear Kitty"
	KittyUIFrame.default = KittyUI_OnDefaults
	KittyUIFrame.cancel = KittyUI_OnCancel
	InterfaceOptions_AddCategory(KittyUIFrame)
	-- Update the version display.
	local Version = GetAddOnMetadata("Hear Kitty", "Version")
	if Version then 
		KittyUIFrame_AboutVersionLabel:SetText(string.format(KittyUIFrame_AboutVersionLabel_Text, Version))
	end
end

function KittyUI_Show()
	InterfaceOptionsFrame_OpenToFrame(KittyUIFrame)
end

function KittyUI_OnShow()
	-- When the Hear Kitty Interface Options window is shown, update the state of controls based on current Hear Kitty options.
	KittyUIFrame_EnableSoundsCheck:SetChecked(KittyOptions.Enabled)
	KittyUIFrame_DoubleCritsCheck:SetChecked(KittyOptions.DoubleCrits)
	-- Also, save a copy of their current options so that they can be reset if the user clicks Cancel.
	KittyUICancelOptions.Enabled = KittyOptions.Enabled
	KittyUICancelOptions.DoubleCrits = KittyOptions.DoubleCrits
end

function KittyUI_OnCancel()
	-- Reset all Hear Kitty options to the state they were in when the UI was first launched.
	KittyOptions.Enabled = KittyUICancelOptions.Enabled
	KittyOptions.DoubleCrits = KittyUICancelOptions.DoubleCrits
end

function KittyUI_OnDefaults()
	-- Reset all Hear Kitty options to their defaults.
	KittyResetOptions()
	KittyUI_OnShow()
end

function KittyUIFrame_EnableSoundsCheck_OnClick()
	KittyEnable(KittyUIFrame_EnableSoundsCheck:GetChecked() ~= nil)
	if KittyOptions.Enabled then
		KittyUIFrame_DisabledWarningLabel:Hide()
	else
		KittyUIFrame_DisabledWarningLabel:Show()
	end
	-- Play a sound to illustrate the effects of this option.
	if KittyOptions.Enabled then
		KittyStopTimer()
		KittyPlayOneSound(0)
	end
end

function KittyUIFrame_DoubleCritsCheck_OnClick()
	KittyEnableDoubleCrits(KittyUIFrame_DoubleCritsCheck:GetChecked() ~= nil)
	-- Play a sound to illustrate the effects of this option.
	if KittyOptions.Enabled then
		if KittyOptions.DoubleCrits then
			KittyStopTimer()
			KittyPlaySoundRange(1, 2)
		else
			KittyStopTimer()
			KittyPlayOneSound(2)
		end
	end
end

------------------------------------------------------------
-- Other Hear Kitty UI methods
------------------------------------------------------------

-- Shows a tooltip for a given control if available.
-- The tooltip used will be the string with the name of the control plus "_Tooltip" on the end.
-- The title of the tooltip will be the text on a control with the same name plus "_Label" on the
-- end if available, or otherwise the actual text on the control if there is any.  If the tooltip text
-- OR title is missing, no tooltip is displayed.
function KittyUI_TooltipOn(this)
	local TooltipText = getglobal(this:GetName() .. "_Tooltip")
	if TooltipText then
		local Label
		local FontString = getglobal(this:GetName() .. "_Label")
		if FontString then
			Label = FontString:GetText()
		elseif this.GetText and this:GetText() then
			Label = this:GetText()
		end
		if Label then
			GameTooltip:ClearLines()
			GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT")
			GameTooltip:AddLine(Label, 1, 1, 1, 1)
			GameTooltip:AddLine(TooltipText, nil, nil, nil, 1, 1)
			GameTooltip:Show()
		end
	end
end

-- Hides the game tooltip.
function KittyUI_TooltipOff()
	GameTooltip:Hide()
end
